IF EXISTS ( SELECT * FROM SYS.OBJECTS 
	WHERE NAME = 'P_GERA_CONCILIACAO_EQUALSCORE')
BEGIN 
	DROP PROCEDURE P_GERA_CONCILIACAO_EQUALSCORE
END
GO

CREATE PROCEDURE [dbo].[P_GERA_CONCILIACAO_EQUALSCORE] AS
SET NOCOUNT ON;


DECLARE @DataInicio DATE = CONVERT(DATE,GETDATE()-5)
DECLARE @DataTermino DATE = CONVERT(DATE,GETDATE())

-- VARIAVEIS AUXILIARES
DECLARE @CD_CTR_TABLE BIGINT
DECLARE @ID_REMESSA BIGINT
DECLARE @IDT_LOTE INT
DECLARE @CD_CTR INT
DECLARE @VALIDA_PARCELA_LOTE INT
DECLARE @COUNT INT

-- DECLARE DO CURSOR DA TABELA EQUALSCORE_IMPORTACAO
DECLARE @CD_GRUPO BIGINT
DECLARE @IDT_REDE INT
DECLARE @DESCR_REDE VARCHAR(4000)
DECLARE @TIPO_MOVIMENTO VARCHAR(4000)
DECLARE @DATA_MOVIMENTO DATE
DECLARE @LOTE VARCHAR(4000)
DECLARE @NUMERO_PARCELA INT
DECLARE @BANCO INT 
DECLARE @AGENCIA INT
DECLARE @CONTA INT
DECLARE @VALOR_BRUTO MONEY
DECLARE @VALOR_COMISSAO MONEY
DECLARE @VALOR_LIQUIDO MONEY
DECLARE @TAXA_ADMINISTRADORA MONEY
DECLARE @BANDEIRA INT
DECLARE @NOME_BANDEIRA VARCHAR(4000)
DECLARE @PRODUTO INT
DECLARE @DESCRICAO_PRODUTO VARCHAR(4000)
DECLARE @DATA_VENDA DATE
DECLARE @HR_VENDA TIME
DECLARE @AUTORIZACAO VARCHAR(4000)
DECLARE @NSU VARCHAR(4000)
DECLARE @NRCARTAO VARCHAR(4000)
DECLARE @CD_TERMINAL VARCHAR(200)
DECLARE @TOTAL_PARCELAS INT
DECLARE @STATUS_VENDA INT
DECLARE @SITUACAO_CONCILIACAO INT
DECLARE @DATA_VENCIMENTO_PARCELA DATE
DECLARE @NUMERO_UNICO_ERP BIGINT
DECLARE @CD_EMP INT
DECLARE @CD_FILIAL INT
DECLARE @CD_VD INT
DECLARE @CD_TRANSACAO_REDE INT
DECLARE @INI INT = 1


   DECLARE LOTE_IMP CURSOR FAST_FORWARD READ_ONLY FOR
   -- INSERT NA TABELA CONCILIACAO_CARTOES_LINX_CONCILIADOR_LOTE

   SELECT DISTINCT
			cd_ctr,
			1 AS CD_GRUPO, -- CAST(FILIACAO_ESTABELECIMENTO AS BIGINT) AS CD_GRUPO,
		  CAST(ADQUIRENTE AS INT) AS IDT_REDE,
          CAST(NOME_ADQUIRENTE AS VARCHAR) AS DESCR_REDE,
          CAST(TIPO_MOVIMENTO AS VARCHAR) AS TIPO_MOVIMENTO,
          CAST(DATA_MOVIMENTO AS DATE) AS DATA_MOVIMENTO,
          CAST(LOTE AS VARCHAR) AS LOTE,
          CAST(NUMERO_PARCELA AS INT) AS NUMERO_PARCELA,
          CAST(BANCO AS INT) AS BANCO,
          CAST(AGENCIA AS INT) AS AGENCIA,
          CAST(CONTA AS INT) AS CONTA,
          CAST(REPLACE(REPLACE(VALOR_BRUTO, '.', ''), ',', '.')  as MONEY) AS VALOR_BRUTO,
		  CAST(REPLACE(REPLACE(VALOR_COMISSAO, '.', ''), ',', '.')  as MONEY) AS VALOR_COMISSAO,
		  CAST(REPLACE(REPLACE(VALOR_LIQUIDO, '.', ''), ',', '.')  as MONEY) AS VALOR_LIQUIDO,
		  ROUND((100*CAST(REPLACE(REPLACE(VALOR_COMISSAO, '.', ''), ',', '.')  as MONEY)/CAST(REPLACE(REPLACE(VALOR_BRUTO, '.', ''), ',', '.')  as MONEY)),2) AS TAXA_ADMINISTRADORA,
          CAST(BANDEIRA AS INT) AS BANDEIRA,
          CAST(NOME_BANDEIRA AS VARCHAR) AS NOME_BANDEIRA,
          CAST(PRODUTO AS INT) AS PRODUTO,
          CASE WHEN DESCRICAO_PRODUTO LIKE ('%Cr?dito ? Vista%')THEN 'Crédito à Vista'
	           WHEN DESCRICAO_PRODUTO LIKE ('%CrÃ©dito Ã  Vista%')THEN 'Crédito à Vista'
	           WHEN DESCRICAO_PRODUTO LIKE ('%Credito a Vista%')THEN 'Crédito à Vista'
	           WHEN DESCRICAO_PRODUTO LIKE ('%D?bito ? Vista%')THEN 'Débito à Vista'
	           WHEN DESCRICAO_PRODUTO LIKE ('%DÃ©bito Ã  Vista%')THEN 'Débito à Vista'
	           WHEN DESCRICAO_PRODUTO LIKE ('%Debito a Vista%')THEN 'Débito à Vista'
	           WHEN DESCRICAO_PRODUTO LIKE ('%Pagto InstantÃ¢neo%')THEN 'Pagto Instantâneo'
			   WHEN DESCRICAO_PRODUTO LIKE ('%Pagto Instantaneo%')THEN 'Pagto Instantâneo'
			   WHEN DESCRICAO_PRODUTO LIKE ('%PrÃ©-Pago CrÃ©dito%')THEN 'Pré-Pago Crédito'
			   WHEN DESCRICAO_PRODUTO LIKE ('%Pre-Pago Credito%')THEN 'Pré-Pago Crédito'
			   WHEN DESCRICAO_PRODUTO LIKE ('%PrÃ©-Pago DÃ©bito%')THEN 'Pré-Pago Débito'
			   WHEN DESCRICAO_PRODUTO LIKE ('%Pre-Pago Debito%')THEN 'Pré-Pago Débito'
	           ELSE DESCRICAO_PRODUTO
          END AS DESCRICAO_PRODUTO,
          CAST(DATA_VENDA AS DATE) AS DATA_VENDA,
          CONVERT(time, CASE WHEN HORA_VENDA = '' THEN '00:00:00' ELSE CONCAT(SUBSTRING(CASE WHEN LEN(HORA_VENDA) < 6 THEN CONCAT('0', HORA_VENDA) ELSE HORA_VENDA END, 1,2),':', SUBSTRING(CASE WHEN LEN(HORA_VENDA) < 6 THEN CONCAT('0', HORA_VENDA) ELSE HORA_VENDA END, 3,2),':', SUBSTRING(CASE WHEN LEN(HORA_VENDA) < 6 THEN CONCAT('0', HORA_VENDA) ELSE HORA_VENDA END, 5,2)) END , 0) AS HR_VENDA,
          CAST(AUTORIZACAO AS VARCHAR) AS AUTORIZACAO,
          CAST(NSU AS VARCHAR) AS NSU,
          CAST(NRCARTAO AS VARCHAR) AS NRCARTAO,
          ISNULL(CAST(dbo.F_NUMEROS(TERMINAL) AS VARCHAR), 0) AS CD_TERMINAL,
          CAST(TOTAL_PARCELAS AS INT) AS TOTAL_PARCELAS,
          CAST(STATUS_VENDA AS INT) AS STATUS_VENDA,
          CAST(SITUACAO_CONCILIACAO AS INT) AS SITUACAO_CONCILIACAO,
          CAST(DATA_VENCIMENTO_PARCELA AS DATE) AS DATA_VENCIMENTO_PARCELA,
          CAST(SUBSTRING(NUMERO_UNICO_ERP,1,17) AS BIGINT) AS NUMERO_UNICO_ERP,
		  1 AS CD_EMP,
		  CAST(SUBSTRING(NUMERO_UNICO_ERP, 2, 4) AS INT) AS CD_FILIAL,
		  CAST(SUBSTRING(NUMERO_UNICO_ERP, 6, 8) AS INT) AS CD_VD,
          CASE WHEN DESCRICAO_PRODUTO LIKE ('%Cr?dito ? Vista%')THEN 8001
	           WHEN DESCRICAO_PRODUTO LIKE ('%CrÃ©dito Ã  Vista%')THEN 8001
	           WHEN DESCRICAO_PRODUTO LIKE ('%Credito a Vista%')THEN 8001
			   WHEN DESCRICAO_PRODUTO LIKE ('%Crédito à Vista%')THEN 8001
			   WHEN DESCRICAO_PRODUTO LIKE ('%Parcelado Loja%')THEN 8001
	           WHEN DESCRICAO_PRODUTO LIKE ('%D?bito ? Vista%')THEN 8002
	           WHEN DESCRICAO_PRODUTO LIKE ('%DÃ©bito Ã  Vista%')THEN 8002
	           WHEN DESCRICAO_PRODUTO LIKE ('%Debito a Vista%')THEN 8002
			   WHEN DESCRICAO_PRODUTO LIKE ('%Débito à Vista%')THEN 8002
			   WHEN DESCRICAO_PRODUTO LIKE ('%PrÃ©-Pago CrÃ©dito%')THEN 8001
			   WHEN DESCRICAO_PRODUTO LIKE ('%Pre-Pago Credito%')THEN 8001
			   WHEN DESCRICAO_PRODUTO LIKE ('%Pré-Pago Crédito%')THEN 8001
			   WHEN DESCRICAO_PRODUTO LIKE ('%PrÃ©-Pago DÃ©bito%')THEN 8002
			   WHEN DESCRICAO_PRODUTO LIKE ('%Pre-Pago Debito%')THEN 8002
			   WHEN DESCRICAO_PRODUTO LIKE ('%Pré-Pago Débito%')THEN 8002
	           ELSE 8000
          END AS CD_TRANSACAO_REDE
	 FROM EQUALSCORE_IMPORTACAO 
    WHERE NUMERO_UNICO_ERP <> '' AND LEN(NUMERO_UNICO_ERP) = 17 
	AND ((CAST(DATA_VENDA AS DATE) BETWEEN @DataInicio AND @DataTermino AND CAST(TIPO_MOVIMENTO AS VARCHAR) IN ('A3', 'A4'))
		 OR (CAST(DATA_VENCIMENTO_PARCELA AS DATE) BETWEEN @DataInicio AND @DataTermino AND CAST(TIPO_MOVIMENTO AS VARCHAR) NOT IN ('A3', 'A4'))
		 OR (CAST(DATA_MOVIMENTO AS DATE) BETWEEN @DataInicio AND @DataTermino AND CAST(TIPO_MOVIMENTO AS VARCHAR) IN ('A3', 'A4'))
		 )
	--AND data ou datavencimento ou DATA_MOVIMENTO parcela between
	AND ISNULL(RegistroProcessado,0) = 0
	AND CAST(REPLACE(REPLACE(VALOR_BRUTO, '.', ''), ',', '.')  as MONEY) > 0
    ORDER BY TIPO_MOVIMENTO, DATA_MOVIMENTO, NUMERO_PARCELA -- LOTE, TIPO_MOVIMENTO, NUMERO_PARCELA;
	
   OPEN LOTE_IMP;
   FETCH NEXT FROM LOTE_IMP
   INTO  @CD_CTR_TABLE, @CD_GRUPO, @IDT_REDE, @DESCR_REDE, @TIPO_MOVIMENTO, @DATA_MOVIMENTO, @LOTE, @NUMERO_PARCELA, 
        @BANCO, @AGENCIA, @CONTA, @VALOR_BRUTO, @VALOR_COMISSAO, @VALOR_LIQUIDO, @TAXA_ADMINISTRADORA, @BANDEIRA, @NOME_BANDEIRA, 
        @PRODUTO, @DESCRICAO_PRODUTO, @DATA_VENDA, @HR_VENDA, @AUTORIZACAO, @NSU, @NRCARTAO, @CD_TERMINAL, 
        @TOTAL_PARCELAS, @STATUS_VENDA, @SITUACAO_CONCILIACAO, @DATA_VENCIMENTO_PARCELA, @NUMERO_UNICO_ERP, 
        @CD_EMP, @CD_FILIAL, @CD_VD, @CD_TRANSACAO_REDE

   WHILE @@FETCH_STATUS = 0
   BEGIN
      SET @IDT_LOTE = ISNULL((SELECT MAX(IDT_LOTE)
                                FROM CONCILIACAO_CARTOES_LINX_CONCILIADOR_LOTE
                               WHERE LOTE = @LOTE AND CD_FILIAL = @CD_FILIAL), 0)

      IF (@IDT_LOTE = 0 AND @TIPO_MOVIMENTO IN ('A3','A4')) /*Só grava o cabeçalho do lote a partir do registro CONCILIADO A3 OU A4*/
	  BEGIN
		SET @IDT_LOTE = ISNULL((SELECT MAX(IDT_LOTE) FROM CONCILIACAO_CARTOES_LINX_CONCILIADOR_LOTE), 0) + 1
		INSERT INTO CONCILIACAO_CARTOES_LINX_CONCILIADOR_LOTE (IDT_LOTE , LOTE , CD_EMP , CD_FILIAL , CD_GRUPO , TPT_REGISTRO, CD_TERMINAL , QTD_REGISTROS_VENDAS, NR_PARCELAS    , VLR_BRUTO, VLR_LIQUIDO, TAXA_ADMINISTRADORA, DT_LOTE        , ST_STATUS            , CD_BANCO , AGENCIA , CONTACORRENTE, CD_BANDEIRA, DS_BANDEIRA   )
													   VALUES (@IDT_LOTE, @LOTE, @CD_EMP, @CD_FILIAL, @CD_GRUPO, 7           , @CD_TERMINAL, 0                   , @TOTAL_PARCELAS, 0        , 0          ,                   0, @DATA_MOVIMENTO, @SITUACAO_CONCILIACAO, @BANCO   , @AGENCIA, @CONTA       , @BANDEIRA  , @NOME_BANDEIRA)
	  END 

	  IF ISNULL(@IDT_LOTE,0) > 0
	  BEGIN

		  IF (@TIPO_MOVIMENTO IN ('A3','A4'))
		  BEGIN

			 UPDATE CONCILIACAO_CARTOES_LINX_CONCILIADOR_LOTE 
				SET VLR_BRUTO = VLR_BRUTO + @VALOR_BRUTO,
					VLR_LIQUIDO = VLR_LIQUIDO + @VALOR_LIQUIDO,
					DT_LOTE = @DATA_MOVIMENTO
			  WHERE IDT_LOTE = @IDT_LOTE
					AND LOTE = @LOTE
					AND CD_FILIAL = @CD_FILIAL

			 UPDATE CONCILIACAO_CARTOES_LINX_CONCILIADOR_LOTE 
				SET TAXA_ADMINISTRADORA = ROUND((VLR_BRUTO - VLR_LIQUIDO) * 100 / VLR_BRUTO,2)
			  WHERE IDT_LOTE = @IDT_LOTE
					AND LOTE = @LOTE
					AND CD_FILIAL = @CD_FILIAL

			 SET @CD_CTR = ISNULL((SELECT MAX(CD_CTR)
									 FROM CONCILIACAO_CARTOES_LINX_CONCILIADOR
									WHERE IDT_TRANSACAO = @NUMERO_UNICO_ERP AND
										  IDT_LOTE_REDE = @IDT_LOTE), 0)

			 IF (@CD_CTR = 0)
			 BEGIn

				DECLARE @ContextInfo VARBINARY(128);
				SET @ContextInfo = CAST('P_GERA_CONCILIACAO_EQUALSCORE' AS VARBINARY(128));
				--select @ContextInfo

				SET CONTEXT_INFO @ContextInfo;


				INSERT INTO CONCILIACAO_CARTOES_LINX_CONCILIADOR (CD_EMP, CD_FILIAL, TPT_REGISTRO, CD_GRUPO, CD_TERMINAL, 
																  IDT_TRANSACAO, IDT_LOTE_REDE, DT_VENDA, NSU_REDE, CD_AUTORIZACAO, 
																  CD_BANDEIRA_REDE, CD_TRANSACAO_REDE, TPT_PARCELAMENTO_REDE, NR_PARCELAS_REDE, VLR_BRUTO_REDE, 
																  VLR_LIQUIDO_REDE, NR_CARTAO_REDE, ST_REDE, TPT_CAPTURA_REDE, ST_CONCILIACAO, 
																  HR_TRANSACAO)
														  VALUES (@CD_EMP, @CD_FILIAL, 3, @CD_GRUPO, @CD_TERMINAL,
																  @NUMERO_UNICO_ERP, @IDT_LOTE, @DATA_VENDA, @NSU, @AUTORIZACAO,
																  @BANDEIRA, @CD_TRANSACAO_REDE, NULL, @TOTAL_PARCELAS, 0, 
																  0, @NRCARTAO, @STATUS_VENDA, NULL, @SITUACAO_CONCILIACAO,
																  @HR_VENDA)
            
				SET @CD_CTR = (SELECT SCOPE_IDENTITY())

				UPDATE CONCILIACAO_CARTOES_LINX_CONCILIADOR_LOTE 
				   SET QTD_REGISTROS_VENDAS = QTD_REGISTROS_VENDAS + 1
				 WHERE IDT_LOTE = @IDT_LOTE

            
				--PRINT 'LOTE.CD_CTR.FILIAL.VENDA: ' + CAST(@LOTE AS VARCHAR) + '.' + CAST(@CD_CTR AS VARCHAR) + '.' + CAST(@CD_FILIAL AS VARCHAR) + '.' + CAST(@CD_VD AS VARCHAR) 
				BEGIN TRY
			
					INSERT INTO CONCILIACAO_CARTOES_FINAL (CD_EMP, CD_FILIAL, CD_CX, NR_ECF, DT_VD, 
														   VLR_VENDA, COD_SIT, IDT_REDE, DESCR_REDE, IDT_PRODUTO, 
														   DESCR_PRODUTO, IDT_BANDEIRA, DESCR_BANDEIRA, NUM_PARCELAS, COD_AUTORIZ, 
														   ST_VENDA, NSU_SITEF, CD_CTR_PDV_VD_TEF, CD_VD, IDT_TRANSACAO, 
														   CD_CTR_CONCILIADOR, CD_RECTO_TEF, CD_CTR_PDV_CUPOM_NAO_FISCAL_TEF, CD_CTR_ID_QR_LINX)

					SELECT TOP 1 @CD_EMP AS CD_EMP,
						   PV.CD_FILIAL AS CD_FILIAL,
						   PV.CD_CX AS CD_CX,
						   PV.NR_ECF AS NR_ECF,
						   PV.DT_VD AS DT_VD,
						   COALESCE(PRIORIDADE1.VL_CARTAO , PRIORIDADE2.VL_CARTAO, PV.VLR_LIQ_VD) AS VLR_VENDA,
						   0 AS COD_SIT,
						   @IDT_REDE AS IDT_REDE,
						   @DESCR_REDE AS DESCR_REDE,
						   @PRODUTO AS IDT_PRODUTO,
						   @DESCRICAO_PRODUTO AS DESCR_PRODUTO,
						   @BANDEIRA AS IDT_BANDEIRA,
						   @NOME_BANDEIRA AS DESCR_BANDEIRA,
						   @TOTAL_PARCELAS AS NUM_PARCELAS,
						   @AUTORIZACAO AS COD_AUTORIZ,
						   @STATUS_VENDA AS ST_VENDA,
						   @NSU AS NSU_SITEF,
						   COALESCE(PRIORIDADE1.CD_CTR, PRIORIDADE2.CD_CTR) AS CD_CTR_PDV_VD_TEF,
						   PV.CD_VD AS CD_VD,
						   @NUMERO_UNICO_ERP AS IDT_TRANSACAO,
						   @CD_CTR AS CD_CTR_CONCILIADOR,
						   0 AS CD_RECTO_TEF,
						   0 AS CD_CTR_PDV_CUPOM_NAO_FISCAL_TEF,
						   QR.CD_CTR_ID AS CD_CTR_ID_QR_LINX
					  FROM PDV_VD PV
						   OUTER APPLY(SELECT TOP 1 * FROM PDV_VD_TEF PVT 
										WHERE PV.CD_EMP = PVT.CD_EMP
												   AND PV.CD_FILIAL = PVT.CD_FILIAL
												   AND PV.CD_VD = PVT.CD_VD
												   AND (( CONVERT(VARCHAR,PVT.NSU_SITEF)  = CONVERT(VARCHAR,@NSU) AND @NSU <> '0') OR 
																			    PVT.NR_AUTORIZACAO COLLATE database_Default = @AUTORIZACAO  COLLATE database_Default  
																		 AND (PVT.QTDE_PARCELAS 	   = @TOTAL_PARCELAS)
																	     AND (PVT.VL_CARTAO = @VALOR_BRUTO)
														)
										) PRIORIDADE1 /*Tenta conciliar com o mais completo possivel. Se não achar, concilia com o de baixo (CD_VD ja retorna do equalscore)*/
						   OUTER APPLY(SELECT TOP 1 * FROM PDV_VD_TEF PVT 
										WHERE PV.CD_EMP = PVT.CD_EMP
												   AND PV.CD_FILIAL = PVT.CD_FILIAL
												   AND PV.CD_VD = PVT.CD_VD
										) PRIORIDADE2
						   LEFT JOIN PDV_VD_PDV_NSU_QR_LINX QR ON PV.CD_EMP = QR.CD_EMP
															  AND PV.CD_FILIAL = QR.CD_FILIAL
															  AND PV.CD_VD = QR.CD_VD
					 WHERE PV.CD_FILIAL = @CD_FILIAL
					   AND PV.CD_VD = @CD_VD
					 GROUP BY PV.CD_FILIAL, PV.CD_CX, PV.NR_ECF, PV.DT_VD, 
							  COALESCE(PRIORIDADE1.VL_CARTAO , PRIORIDADE2.VL_CARTAO, PV.VLR_LIQ_VD), COALESCE(PRIORIDADE1.CD_CTR, PRIORIDADE2.CD_CTR), PV.CD_VD, QR.CD_CTR_ID
					UNION ALL
					SELECT @CD_EMP,
			 			   PCNF.CD_FILIAL,
						   PCNF.CD_CX,
						   PCNF.NR_COO as NR_ECF,
						   PCNF.DT_CUPOM as DT_VD,
						   PRT.VL_CARTAO as VLR_VENDA,
						   0 AS COD_SIT,
						   @IDT_REDE AS IDT_REDE,
						   @DESCR_REDE AS DESCR_REDE,
						   @PRODUTO AS IDT_PRODUTO,
						   @DESCRICAO_PRODUTO AS DESCR_PRODUTO,
						   @BANDEIRA AS IDT_BANDEIRA,
						   @NOME_BANDEIRA AS DESCR_BANDEIRA,
						   @TOTAL_PARCELAS AS NUM_PARCELAS,
						   @AUTORIZACAO AS COD_AUTORIZ,
						   @STATUS_VENDA AS ST_VENDA,
						   @NSU AS NSU_SITEF,
						   PCNF.CD_CTR AS CD_CTR_PDV_VD_TEF,
						   PCNF.NR_COO as CD_VD,
						   @NUMERO_UNICO_ERP AS IDT_TRANSACAO,
						   @CD_CTR AS CD_CTR_CONCILIADOR,
						   PRT.CD_RECTO_TEF,
			 			   PCNF.CD_CTR AS CD_CTR_PDV_CUPOM_NAO_FISCAL_TEF,
						   0 AS QR_LINX
					  FROM PDV_CUPOM_NAO_FISCAL PCNF
						   INNER JOIN PDV_CUPOM_NAO_FISCAL_TEF PCNFT ON PCNF.CD_EMP = PCNFT.CD_EMP
																	AND PCNF.CD_FILIAL = PCNFT.CD_FILIAL
																	AND PCNF.CD_CTR = PCNFT.CD_CTR
						   INNER JOIN PDV_RECBTO_TEF PRT ON PCNF.CD_EMP = PRT.CD_EMP
														AND PCNF.CD_FILIAL = PRT.CD_FILIAL
														AND PCNFT.CD_RECTO_TEF = PRT.CD_RECTO_TEF
					 WHERE prt.CD_RECTO_TEF = @CD_VD
					   AND PCNF.CD_FILIAL = @CD_FILIAL

				END TRY
				BEGIN CATCH
					PRINT 'Não foi possivel inserir a filial' + convert(varchar, @cd_filial) + ' para a venda ' + convert(varchar,@cd_vd)
				END CATCH

			 END

			 UPDATE CONCILIACAO_CARTOES_LINX_CONCILIADOR
				SET VLR_BRUTO_REDE = VLR_BRUTO_REDE + @VALOR_BRUTO,
					VLR_LIQUIDO_REDE = VLR_LIQUIDO_REDE + @VALOR_LIQUIDO
			  WHERE CD_CTR = @CD_CTR
		  END 
		  ELSE 
		  BEGIN

			 IF (@TIPO_MOVIMENTO  IN( 'D1','D2')) 
			 BEGIN
				UPDATE CONCILIACAO_CARTOES_LINX_CONCILIADOR_LOTE 
				   SET CD_BANCO = @BANCO,
					   AGENCIA = @AGENCIA,
					   CONTACORRENTE = @CONTA
				 WHERE IDT_LOTE = @IDT_LOTE

				SET @VALIDA_PARCELA_LOTE = (SELECT COUNT(*)
											  FROM CONCILIACAO_CARTOES_LINX_CONCILIADOR_PGTO
											 WHERE PARCELA_LOTE = @NUMERO_PARCELA AND
												   IDT_LOTE = @IDT_LOTE)
		 
				IF (@VALIDA_PARCELA_LOTE = 0)
				BEGIN
				   INSERT INTO CONCILIACAO_CARTOES_LINX_CONCILIADOR_PGTO (IDT_LOTE, CD_EMP, CD_FILIAL, TPT_REGISTRO, PARCELA_LOTE, VLR_BRUTO, 
																		  VLR_LIQUIDO, DT_PAGAMENTO, ST_STATUS, LOTE_PAGAMENTO, 
																		  CD_BANCO, AGENCIA, CONTACORRENTE)
																  VALUES (@IDT_LOTE, @CD_EMP, @CD_FILIAL, 8, @NUMERO_PARCELA, 0,
																		  0, @DATA_VENCIMENTO_PARCELA, @SITUACAO_CONCILIACAO, @LOTE, 
																		  @BANCO, @AGENCIA, @CONTA)
				END


				UPDATE CONCILIACAO_CARTOES_LINX_CONCILIADOR_PGTO
				   SET VLR_BRUTO = VLR_BRUTO + @VALOR_BRUTO,
					   VLR_LIQUIDO = VLR_LIQUIDO + @VALOR_LIQUIDO
				 WHERE PARCELA_LOTE = @NUMERO_PARCELA AND
					   IDT_LOTE = @IDT_LOTE
			 END
		  END

			  UPDATE EQUALSCORE_IMPORTACAO
				SET RegistroProcessado = 1
				WHERE CD_CTR = @CD_CTR_TABLE
		END

		PRINT 'Registro:' + convert(varchar, @INI)
		
		set @INI = @INI + 1;

	

      FETCH NEXT FROM LOTE_IMP
       INTO  @CD_CTR_TABLE, @CD_GRUPO, @IDT_REDE, @DESCR_REDE, @TIPO_MOVIMENTO, @DATA_MOVIMENTO, @LOTE, @NUMERO_PARCELA, 
            @BANCO, @AGENCIA, @CONTA, @VALOR_BRUTO, @VALOR_COMISSAO, @VALOR_LIQUIDO, @TAXA_ADMINISTRADORA, @BANDEIRA, @NOME_BANDEIRA,
            @PRODUTO, @DESCRICAO_PRODUTO, @DATA_VENDA, @HR_VENDA, @AUTORIZACAO, @NSU, @NRCARTAO, @CD_TERMINAL, 
            @TOTAL_PARCELAS, @STATUS_VENDA, @SITUACAO_CONCILIACAO, @DATA_VENCIMENTO_PARCELA, @NUMERO_UNICO_ERP, 
            @CD_EMP, @CD_FILIAL, @CD_VD, @CD_TRANSACAO_REDE
   END

   CLOSE LOTE_IMP
   DEALLOCATE LOTE_IMP; 
